package com.wuban.tron.explore.controller;

import com.wuban.tron.explore.param.request.CensusRequest;
import com.wuban.tron.explore.service.TransactionService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@Slf4j
@RestController
@RequestMapping("/census")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class CensusController {

    private final TransactionService transactionService;

    @RequestMapping(method = RequestMethod.POST)
    public void census(@RequestBody @Valid CensusRequest reqParam) {
        new Thread(()->this.transactionService.censusBlockByDate(reqParam.getStartDate(), reqParam.getEndDate())).start();
    }

}
