package com.wuban.tron.explore.fetch;

import com.wuban.tron.explore.domain.TronResponseData;
import lombok.extern.slf4j.Slf4j;

/**
 *  <core>区块服务引擎</core>
 *
 * @author sky
 * @date 2020/11/04
 */
@Slf4j
public class Engine {

    /**
     * 线程池
     */
    private Executor executor;

    /**
     * 监控线程,负责异常重启
     */
    private Thread monitor;

    /**
     * 区块数据猎手
     */
    private BlockDataFetcher<TronResponseData> fetcher;

    /**
     * 区块数据处理者
     */
    private BlockDataHandler handler;

    public Engine(String name) {
        this.executor = new Executor(name);
        this.monitor = new Thread(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(1000);
                    if (this.handler != null && this.handler.isShutdown()) {
                        log.error("{} engine shutdown now restart ", name);
                        reload();
                    }
                } catch (final InterruptedException e) {
                    log.error("{} engine monitor interrupted ", name);
                    break;
                } catch (final Exception e) {
                    log.error("{} engine monitor error ", name, e);
                }
            }
        }, name.concat("_monitor"));
        this.monitor.start();
    }

    public synchronized void start() {
        this.handler = new BlockDataHandler();
        this.fetcher = new BlockDataFetcher(this.handler);
        this.executor.execute(this.handler);

        //int cupNum = ThreadPoolUtil.getCupNum()*2;
        for (int i = 0; i <= 10; i++) {
            this.executor.execute(this.fetcher);
        }
    }

    public synchronized void reload() {
        this.executor.shutdown();
        this.executor.rebuild();
        start();
    }

}
