package com.wuban.tron.explore.service;

import com.github.pagehelper.PageInfo;
import com.wuban.tron.explore.domain.TronResponseData;
import com.wuban.tron.explore.entity.Transaction;
import com.wuban.tron.explore.entity.example.TransactionExample;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 *  <core>区块服务接口方法</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface TransactionService {

    /**
     * 持久化区块头、交易、hex信息
     *
     * @param dataList
     */
    void save(List<TronResponseData> dataList);

    Long getBlockMinTime();

    /**
     * 统计区块信息:前一天数据
     */
    void censusBlockByLastDay();

    /**
     * 统计区块信息:根据具体日期统计
     *
     * @param startDate 开始日期:yyyy-MM-dd
     * @param endDate   结束日期:yyyy-MM-dd
     */
    void censusBlockByDate(String startDate, String endDate);

    /**
     * 分页查询
     *
     * @param startIndex 页码
     * @param pageSize  每页记录数
     * @param example   检索条件
     * @return 分页列表
     */
    PageInfo<Transaction> getByPageWithCategory(Integer startIndex, Integer pageSize, TransactionExample example);

    /**
     * 根据条件检索
     *
     * @param example 检索条件
     * @return
     */
    List<Transaction> getByExample(@Param("example") TransactionExample example);

    /**
     * 根据账户地址查询交易信息
     *
     * @param address 账户地址
     *
     * @param type
     *      <ul>
     *          <li>1: 7天交易</li>
     *          <li>2: 14天交易</li>
     *          <li>3: 30内交易</li>
     *      </ul>
     *
     * @param startIndex
     * @param pageSize
     * @return
     */
    PageInfo<Transaction> selectListByAddress(String address, int type, Integer startIndex, Integer pageSize);

    void init();

}
