package com.wuban.tron.explore.service;

import com.wuban.tron.explore.domain.TronAccount;
import com.wuban.tron.explore.domain.TronResponseArrayData;
import com.wuban.tron.explore.domain.TronResponseData;

/**
 *  <core>波场区块服务接口</core>
 *
 * @author sky
 * @date 2020/11/02
 */
public interface TronService {

    /**
     * 按照高度查询block
     *
     * @param blockNum 是块的高度
     */
    TronResponseData getBlockByNum(Long blockNum);

    /**
     * 查询最新的几个块
     *
     * @param num 块的数量
     */
    TronResponseArrayData getBlockByLatestNum(Integer num);

    /**
     * 根据地址获取账户信息
     *
     * @param address 账户地址
     * @return  账号信息
     */
    TronAccount getAccount(String address);

}
