package com.wuban.tron.explore.entity;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 区块、交易、账户统计表
 * @author sky
 * @date 2020-11-24
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PRIVATE)
public class Census {
		/**
     * 
     */
	 private Long id; 
		/**
     * 总交易数
     */
	 private Long totalTrans; 
		/**
     * 总区块大小
     */
	 private Long totalBlockSize; 
		/**
     * 总账户数
     */
	 private Long totalAccount; 
		
	public static Census getInstance() {
	return Census.builder()
		       .id(0L)
		       .totalTrans(0L)
		       .totalBlockSize(0L)
		       .totalAccount(0L)
		       .build();
	}
}