package com.wuban.tron.explore.param.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Builder;
import lombok.Data;

/**
 * 交易详情MODEL
 *
 * @author wuban-team
 * @date 2020-11-16
 */
@Data
@Builder
public class TransInfoModel {

    private String hash;
    private String blockHash;
    @JsonProperty(value="BlockNumber")
    private Object blockNumber;
    private String timestamp;
    private String from;
    private String to;
    private String value;
    private String v;
    private String gas;
    private String gasPrice;
    private String transactionIndex;
    private String nonce;
    private String input;

    public static TransInfoModel getInstance() {
        return TransInfoModel.builder()
                .hash("")
                .blockHash("")
                .blockNumber(0)
                .timestamp("")
                .from("")
                .to("")
                .value("")
                .v("")
                .gas("")
                .gasPrice("")
                .transactionIndex("")
                .nonce("")
                .input("")
                .blockNumber(null)
                .build();
    }


}
