package com.wuban.tron.explore.dao;

import com.wuban.tron.explore.entity.BlockDayCensus;
import com.wuban.tron.explore.entity.example.BlockDayCensusExample;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <core>区块统计DAO</core>
 *
 * @author sky
 * @date 2020/11/02
 */
@Repository
public interface BlockDayCensusRepository {

    /**
     * 添加记录
     * @param record
     * @return
     */
    int insert(@Param("record") BlockDayCensus record);

    /**
     * 删除记录
     * @param id
     * @return
     */
    void deleteById(@Param("id") Long id);

    /**
     * 按照时间统计区块信息
     *
     * @param start 开始时间秒
     * @param end   结束时间秒
     * @return BlockDayCensus
     */
    BlockDayCensus censusBlockByTime(@Param("start") Long start, @Param("end") Long end);

    /**
     * 分页查询
     *
     * @param example 查询条件参数
     * @return 分页记录列表
     */
    List<BlockDayCensus> selectByPager(@Param("example") BlockDayCensusExample example);

    /**
     * 根据条件检索列表数据
     *
     * @param example 查询条件参数
     * @return  记录列表
     */
    List<BlockDayCensus> selectByExample(@Param("example") BlockDayCensusExample example);


}
